/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FogRenderer {
    private static final int WATER_FOG_DISTANCE = 96;
    private static final List<MobEffectFogFunction> MOB_EFFECT_FOG = Lists.newArrayList((Object[])new MobEffectFogFunction[]{new BlindnessFogFunction(), new DarknessFogFunction()});
    public static final float BIOME_FOG_TRANSITION_TIME = 5000.0f;
    private static float fogRed;
    private static float fogGreen;
    private static float fogBlue;
    private static int targetBiomeFog;
    private static int previousBiomeFog;
    private static long biomeChangedTime;

    public static void setupColor(Camera p_109019_, float p_109020_, ClientLevel p_109021_, int p_109022_, float p_109023_) {
        float $$44;
        LivingEntity $$42;
        FogType $$5 = p_109019_.getFluidInCamera();
        Entity $$6 = p_109019_.getEntity();
        if ($$5 == FogType.WATER) {
            long $$7 = Util.getMillis();
            int $$8 = p_109021_.getBiome(BlockPos.containing(p_109019_.getPosition())).value().getWaterFogColor();
            if (biomeChangedTime < 0L) {
                targetBiomeFog = $$8;
                previousBiomeFog = $$8;
                biomeChangedTime = $$7;
            }
            int $$9 = targetBiomeFog >> 16 & 0xFF;
            int $$10 = targetBiomeFog >> 8 & 0xFF;
            int $$11 = targetBiomeFog & 0xFF;
            int $$12 = previousBiomeFog >> 16 & 0xFF;
            int $$13 = previousBiomeFog >> 8 & 0xFF;
            int $$14 = previousBiomeFog & 0xFF;
            float $$15 = Mth.clamp((float)($$7 - biomeChangedTime) / 5000.0f, 0.0f, 1.0f);
            float $$16 = Mth.lerp($$15, $$12, $$9);
            float $$17 = Mth.lerp($$15, $$13, $$10);
            float $$18 = Mth.lerp($$15, $$14, $$11);
            fogRed = $$16 / 255.0f;
            fogGreen = $$17 / 255.0f;
            fogBlue = $$18 / 255.0f;
            if (targetBiomeFog != $$8) {
                targetBiomeFog = $$8;
                previousBiomeFog = Mth.floor($$16) << 16 | Mth.floor($$17) << 8 | Mth.floor($$18);
                biomeChangedTime = $$7;
            }
        } else if ($$5 == FogType.LAVA) {
            fogRed = 0.6f;
            fogGreen = 0.1f;
            fogBlue = 0.0f;
            biomeChangedTime = -1L;
        } else if ($$5 == FogType.POWDER_SNOW) {
            fogRed = 0.623f;
            fogGreen = 0.734f;
            fogBlue = 0.785f;
            biomeChangedTime = -1L;
            RenderSystem.clearColor(fogRed, fogGreen, fogBlue, 0.0f);
        } else {
            float $$35;
            float $$19 = 0.25f + 0.75f * (float)p_109022_ / 32.0f;
            $$19 = 1.0f - (float)Math.pow($$19, 0.25);
            Vec3 $$20 = p_109021_.getSkyColor(p_109019_.getPosition(), p_109020_);
            float $$21 = (float)$$20.x;
            float $$22 = (float)$$20.y;
            float $$23 = (float)$$20.z;
            float $$24 = Mth.clamp(Mth.cos(p_109021_.getTimeOfDay(p_109020_) * ((float)Math.PI * 2)) * 2.0f + 0.5f, 0.0f, 1.0f);
            BiomeManager $$25 = p_109021_.getBiomeManager();
            Vec3 $$26 = p_109019_.getPosition().subtract(2.0, 2.0, 2.0).scale(0.25);
            Vec3 $$27 = CubicSampler.gaussianSampleVec3($$26, (p_109033_, p_109034_, p_109035_) -> p_109021_.effects().getBrightnessDependentFogColor(Vec3.fromRGB24($$25.getNoiseBiomeAtQuart(p_109033_, p_109034_, p_109035_).value().getFogColor()), $$24));
            fogRed = (float)$$27.x();
            fogGreen = (float)$$27.y();
            fogBlue = (float)$$27.z();
            if (p_109022_ >= 4) {
                float[] $$31;
                float $$28 = Mth.sin(p_109021_.getSunAngle(p_109020_)) > 0.0f ? -1.0f : 1.0f;
                Vector3f $$29 = new Vector3f($$28, 0.0f, 0.0f);
                float $$30 = p_109019_.getLookVector().dot((Vector3fc)$$29);
                if ($$30 < 0.0f) {
                    $$30 = 0.0f;
                }
                if ($$30 > 0.0f && ($$31 = p_109021_.effects().getSunriseColor(p_109021_.getTimeOfDay(p_109020_), p_109020_)) != null) {
                    fogRed = fogRed * (1.0f - ($$30 *= $$31[3])) + $$31[0] * $$30;
                    fogGreen = fogGreen * (1.0f - $$30) + $$31[1] * $$30;
                    fogBlue = fogBlue * (1.0f - $$30) + $$31[2] * $$30;
                }
            }
            fogRed += ($$21 - fogRed) * $$19;
            fogGreen += ($$22 - fogGreen) * $$19;
            fogBlue += ($$23 - fogBlue) * $$19;
            float $$32 = p_109021_.getRainLevel(p_109020_);
            if ($$32 > 0.0f) {
                float $$33 = 1.0f - $$32 * 0.5f;
                float $$34 = 1.0f - $$32 * 0.4f;
                fogRed *= $$33;
                fogGreen *= $$33;
                fogBlue *= $$34;
            }
            if (($$35 = p_109021_.getThunderLevel(p_109020_)) > 0.0f) {
                float $$36 = 1.0f - $$35 * 0.5f;
                fogRed *= $$36;
                fogGreen *= $$36;
                fogBlue *= $$36;
            }
            biomeChangedTime = -1L;
        }
        float $$37 = ((float)p_109019_.getPosition().y - (float)p_109021_.getMinBuildHeight()) * p_109021_.getLevelData().getClearColorScale();
        MobEffectFogFunction $$38 = FogRenderer.getPriorityFogFunction($$6, p_109020_);
        if ($$38 != null) {
            LivingEntity $$39 = (LivingEntity)$$6;
            $$37 = $$38.getModifiedVoidDarkness($$39, $$39.getEffect($$38.getMobEffect()), $$37, p_109020_);
        }
        if ($$37 < 1.0f && $$5 != FogType.LAVA && $$5 != FogType.POWDER_SNOW) {
            if ($$37 < 0.0f) {
                $$37 = 0.0f;
            }
            $$37 *= $$37;
            fogRed *= $$37;
            fogGreen *= $$37;
            fogBlue *= $$37;
        }
        if (p_109023_ > 0.0f) {
            fogRed = fogRed * (1.0f - p_109023_) + fogRed * 0.7f * p_109023_;
            fogGreen = fogGreen * (1.0f - p_109023_) + fogGreen * 0.6f * p_109023_;
            fogBlue = fogBlue * (1.0f - p_109023_) + fogBlue * 0.6f * p_109023_;
        }
        if ($$5 == FogType.WATER) {
            if ($$6 instanceof LocalPlayer) {
                float $$40 = ((LocalPlayer)$$6).getWaterVision();
            } else {
                float $$41 = 1.0f;
            }
        } else if ($$6 instanceof LivingEntity && ($$42 = (LivingEntity)$$6).hasEffect(MobEffects.NIGHT_VISION) && !$$42.hasEffect(MobEffects.DARKNESS)) {
            float $$43 = GameRenderer.getNightVisionScale($$42, p_109020_);
        } else {
            $$44 = 0.0f;
        }
        if (fogRed != 0.0f && fogGreen != 0.0f && fogBlue != 0.0f) {
            float $$45 = Math.min(1.0f / fogRed, Math.min(1.0f / fogGreen, 1.0f / fogBlue));
            fogRed = fogRed * (1.0f - $$44) + fogRed * $$45 * $$44;
            fogGreen = fogGreen * (1.0f - $$44) + fogGreen * $$45 * $$44;
            fogBlue = fogBlue * (1.0f - $$44) + fogBlue * $$45 * $$44;
        }
        RenderSystem.clearColor(fogRed, fogGreen, fogBlue, 0.0f);
    }

    public static void setupNoFog() {
        RenderSystem.setShaderFogStart(Float.MAX_VALUE);
    }

    @Nullable
    private static MobEffectFogFunction getPriorityFogFunction(Entity p_234166_, float p_234167_) {
        if (p_234166_ instanceof LivingEntity) {
            LivingEntity $$2 = (LivingEntity)p_234166_;
            return MOB_EFFECT_FOG.stream().filter(p_234171_ -> p_234171_.isEnabled($$2, p_234167_)).findFirst().orElse(null);
        }
        return null;
    }

    public static void setupFog(Camera p_234173_, FogMode p_234174_, float p_234175_, boolean p_234176_, float p_234177_) {
        FogType $$5 = p_234173_.getFluidInCamera();
        Entity $$6 = p_234173_.getEntity();
        FogData $$7 = new FogData(p_234174_);
        MobEffectFogFunction $$8 = FogRenderer.getPriorityFogFunction($$6, p_234177_);
        if ($$5 == FogType.LAVA) {
            if ($$6.isSpectator()) {
                $$7.start = -8.0f;
                $$7.end = p_234175_ * 0.5f;
            } else if ($$6 instanceof LivingEntity && ((LivingEntity)$$6).hasEffect(MobEffects.FIRE_RESISTANCE)) {
                $$7.start = 0.0f;
                $$7.end = 5.0f;
            } else {
                $$7.start = 0.25f;
                $$7.end = 1.0f;
            }
        } else if ($$5 == FogType.POWDER_SNOW) {
            if ($$6.isSpectator()) {
                $$7.start = -8.0f;
                $$7.end = p_234175_ * 0.5f;
            } else {
                $$7.start = 0.0f;
                $$7.end = 2.0f;
            }
        } else if ($$8 != null) {
            LivingEntity $$9 = (LivingEntity)$$6;
            MobEffectInstance $$10 = $$9.getEffect($$8.getMobEffect());
            if ($$10 != null) {
                $$8.setupFog($$7, $$9, $$10, p_234175_, p_234177_);
            }
        } else if ($$5 == FogType.WATER) {
            $$7.start = -8.0f;
            $$7.end = 96.0f;
            if ($$6 instanceof LocalPlayer) {
                LocalPlayer $$11 = (LocalPlayer)$$6;
                $$7.end *= Math.max(0.25f, $$11.getWaterVision());
                Holder<Biome> $$12 = $$11.level().getBiome($$11.blockPosition());
                if ($$12.is(BiomeTags.HAS_CLOSER_WATER_FOG)) {
                    $$7.end *= 0.85f;
                }
            }
            if ($$7.end > p_234175_) {
                $$7.end = p_234175_;
                $$7.shape = FogShape.CYLINDER;
            }
        } else if (p_234176_) {
            $$7.start = p_234175_ * 0.05f;
            $$7.end = Math.min(p_234175_, 192.0f) * 0.5f;
        } else if (p_234174_ == FogMode.FOG_SKY) {
            $$7.start = 0.0f;
            $$7.end = p_234175_;
            $$7.shape = FogShape.CYLINDER;
        } else {
            float $$13 = Mth.clamp(p_234175_ / 10.0f, 4.0f, 64.0f);
            $$7.start = p_234175_ - $$13;
            $$7.end = p_234175_;
            $$7.shape = FogShape.CYLINDER;
        }
        RenderSystem.setShaderFogStart($$7.start);
        RenderSystem.setShaderFogEnd($$7.end);
        RenderSystem.setShaderFogShape($$7.shape);
    }

    public static void levelFogColor() {
        RenderSystem.setShaderFogColor(fogRed, fogGreen, fogBlue);
    }

    static {
        targetBiomeFog = -1;
        previousBiomeFog = -1;
        biomeChangedTime = -1L;
    }

    static interface MobEffectFogFunction {
        public Holder<MobEffect> getMobEffect();

        public void setupFog(FogData var1, LivingEntity var2, MobEffectInstance var3, float var4, float var5);

        default public boolean isEnabled(LivingEntity p_234206_, float p_234207_) {
            return p_234206_.hasEffect(this.getMobEffect());
        }

        default public float getModifiedVoidDarkness(LivingEntity p_234208_, MobEffectInstance p_234209_, float p_234210_, float p_234211_) {
            MobEffectInstance $$4 = p_234208_.getEffect(this.getMobEffect());
            if ($$4 != null) {
                p_234210_ = $$4.endsWithin(19) ? 1.0f - (float)$$4.getDuration() / 20.0f : 0.0f;
            }
            return p_234210_;
        }
    }

    static class FogData {
        public final FogMode mode;
        public float start;
        public float end;
        public FogShape shape = FogShape.SPHERE;

        public FogData(FogMode p_234204_) {
            this.mode = p_234204_;
        }
    }

    public static enum FogMode {
        FOG_SKY,
        FOG_TERRAIN;

    }

    static class BlindnessFogFunction
    implements MobEffectFogFunction {
        BlindnessFogFunction() {
        }

        @Override
        public Holder<MobEffect> getMobEffect() {
            return MobEffects.BLINDNESS;
        }

        @Override
        public void setupFog(FogData p_234181_, LivingEntity p_234182_, MobEffectInstance p_234183_, float p_234184_, float p_234185_) {
            float $$5;
            float f = $$5 = p_234183_.isInfiniteDuration() ? 5.0f : Mth.lerp(Math.min(1.0f, (float)p_234183_.getDuration() / 20.0f), p_234184_, 5.0f);
            if (p_234181_.mode == FogMode.FOG_SKY) {
                p_234181_.start = 0.0f;
                p_234181_.end = $$5 * 0.8f;
            } else {
                p_234181_.start = $$5 * 0.25f;
                p_234181_.end = $$5;
            }
        }
    }

    static class DarknessFogFunction
    implements MobEffectFogFunction {
        DarknessFogFunction() {
        }

        @Override
        public Holder<MobEffect> getMobEffect() {
            return MobEffects.DARKNESS;
        }

        @Override
        public void setupFog(FogData p_234194_, LivingEntity p_234195_, MobEffectInstance p_234196_, float p_234197_, float p_234198_) {
            float $$5 = Mth.lerp(p_234196_.getBlendFactor(p_234195_, p_234198_), p_234197_, 15.0f);
            p_234194_.start = p_234194_.mode == FogMode.FOG_SKY ? 0.0f : $$5 * 0.75f;
            p_234194_.end = $$5;
        }

        @Override
        public float getModifiedVoidDarkness(LivingEntity p_234189_, MobEffectInstance p_234190_, float p_234191_, float p_234192_) {
            return 1.0f - p_234190_.getBlendFactor(p_234189_, p_234192_);
        }
    }
}

